//+------------------------------------------------------------------+
//|                                                   T3MA_ALARM.mq4 |
//|                                     Copyright  2011, Martingeil |
//|                                                    fx.09@mail.ru | 
//+------------------------------------------------------------------+
// Martingeil,       .
#property copyright "Copyright  2011, Martingeil"
#property link      "fx.09@mail.ru"

//---- indicator settings
#property  indicator_chart_window
#property  indicator_buffers 2
#property  indicator_color1  Blue
#property  indicator_color2  Red
//---- indicator parameters
extern int  period = 4; //12
extern int  shift  = 0; //  
//---- indicator buffers
double BufferUp[],BufferDn[];
int q,st=5;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   IndicatorBuffers(2);
//---- drawing settings
   SetIndexStyle(0,DRAW_ARROW,2);
   SetIndexArrow(0,233);
   SetIndexStyle(1,DRAW_ARROW,2);
   SetIndexArrow(1,234);   
   
   SetIndexBuffer(0,BufferUp);//  
   SetIndexBuffer(1,BufferDn);//  
//---- name for DataWindow and indicator subwindow label
   IndicatorShortName("T3MA-ALARM ("+period+")");
//---- initialization done
if(Digits==3 || Digits==5) q=10; 
st=st*q;
return(0);}

int deinit()
{
ObjectDelete("low");
ObjectDelete("high");  
}  
//+----------------------------------------------------------------------+
//| Moving Average of Oscillator                                         |
//+----------------------------------------------------------------------+
int start()
  {
//---- ArraySetAsSeries --------------------------------------------------  
double Ma[500],MaOn[500];
double y0[500],y1[500],y2[500];
int    i,limit=ArraySize(Ma); 
ArraySetAsSeries(Ma,true);
//---- IndicatorCounted --------------------------------------------------
int    counted_bars=IndicatorCounted();
int    limit1=Bars-counted_bars;
       if (limit1>1){limit1=Bars-period-1;} 
//---- EMA --------------------------------------------------------------- 
for(i=limit1; i>=0; i--)  Ma[i]  =iMA(NULL,0,period,0,MODE_EMA,PRICE_CLOSE,i);
for(i=limit1; i>=0; i--)  MaOn[i]=iMAOnArray(Ma,limit,period,0,MODE_EMA,i); 
   
for(i=limit1; i>=0; i--)
   {   
       y0[i+shift]=MaOn[i+shift];
       y1[i+1+shift]=MaOn[i+1+shift];
       y2[i+2+shift]=MaOn[i+2+shift];
       
       if(y0[i+shift]-y1[i+1+shift]<0 && y1[i+1+shift]-y2[i+2+shift]>0){BufferDn[i+1]=High[i+1]+st*Point;}
       if(y0[i+shift]-y1[i+1+shift]>0 && y1[i+1+shift]-y2[i+2+shift]<0){BufferUp[i+1]=Low[i+1]-st*Point;}            
//---- Signal Trend Up || Dn ---------------------------------------------   
       if(y0[i]-y1[i+1]>0) Comment ("\n SWAPLONG = ",MarketInfo(Symbol(),MODE_SWAPLONG),
   "   SWAPSHORT = ",MarketInfo(Symbol(),MODE_SWAPSHORT),"\n BUY TREND ",DoubleToStr(Close[i],Digits));
      
       else if(y0[i]-y1[i+1]<0) Comment ("\n SWAPLONG = ",MarketInfo(Symbol(),MODE_SWAPLONG),
   "   SWAPSHORT = ",MarketInfo(Symbol(),MODE_SWAPSHORT),"\n SELL TREND ",DoubleToStr(Close[i],Digits)); 
   } 


//---- done
return(0);}
//+---------------------------------------------------------------------+

